"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIndicesField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_query_indices = require("../../hooks/use_query_indices");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIndicesField = ({
  selectedIndices,
  onIndexSelect,
  loading
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const {
    indices,
    isLoading
  } = (0, _use_query_indices.useQueryIndices)(query);
  const handleChange = value => {
    var _value$;
    if (value !== null && value !== void 0 && (_value$ = value[0]) !== null && _value$ !== void 0 && _value$.label) {
      onIndexSelect(value[0].label);
    }
  };
  const handleSearchChange = searchValue => {
    setQuery(searchValue);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchPlayground.sources.addIndex.label', {
      defaultMessage: 'Add index'
    }),
    labelType: "legend"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    placeholder: _i18n.i18n.translate('xpack.searchPlayground.sources.addIndex.placeholder', {
      defaultMessage: 'Search for index'
    }),
    async: true,
    isLoading: isLoading,
    onChange: handleChange,
    onSearchChange: handleSearchChange,
    fullWidth: true,
    isDisabled: loading,
    options: indices.map(index => ({
      label: index,
      disabled: selectedIndices.includes(index)
    })),
    isClearable: false
  }));
};
exports.AddIndicesField = AddIndicesField;