"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetUpConnectorPanelForStartChat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/actions-plugin/common");
var _constants = require("../analytics/constants");
var _use_usage_tracker = require("../hooks/use_usage_tracker");
var _use_kibana = require("../hooks/use_kibana");
var _use_load_connectors = require("../hooks/use_load_connectors");
var _start_chat_panel = require("./start_chat_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetUpConnectorPanelForStartChat = () => {
  const [connectorFlyoutOpen, setConnectorFlyoutOpen] = (0, _react.useState)(false);
  const [showCallout, setShowAddedCallout] = (0, _react.useState)(false);
  const {
    services: {
      triggersActionsUi: {
        getAddConnectorFlyout: ConnectorFlyout
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: connectors,
    refetch: refetchConnectors,
    isLoading: isConnectorListLoading
  } = (0, _use_load_connectors.useLoadConnectors)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const handleConnectorCreated = () => {
    refetchConnectors();
    setShowAddedCallout(true);
    setConnectorFlyoutOpen(false);
  };
  const handleSetupGenAiConnector = () => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.genAiConnectorCreated);
    setConnectorFlyoutOpen(true);
  };
  (0, _react.useEffect)(() => {
    if (connectors !== null && connectors !== void 0 && connectors.length) {
      if (showCallout) {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorAdded);
      } else {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorExists);
      }
    } else {
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.genAiConnectorSetup);
    }
  }, [connectors === null || connectors === void 0 ? void 0 : connectors.length, showCallout, usageTracker]);
  if (isConnectorListLoading) {
    return null;
  }
  return connectors !== null && connectors !== void 0 && connectors.length ? showCallout ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.searchPlayground.emptyPrompts.setUpConnector.settled', {
      defaultMessage: '{connectorName} connector added',
      values: {
        connectorName: connectors[0].title
      }
    }),
    iconType: "check",
    color: "success",
    "data-test-subj": "addedConnectorCallout"
  }) : null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_start_chat_panel.StartChatPanel, {
    title: _i18n.i18n.translate('xpack.searchPlayground.emptyPrompts.setUpConnector.title', {
      defaultMessage: 'Connect to LLM'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.emptyPrompts.setUpConnector.description",
      defaultMessage: "You need to connect to a large-language model to use this feature. Start by adding connection details for your LLM provider."
    }),
    dataTestSubj: "connectToLLMChatPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "setupGenAIConnectorButton",
    onClick: handleSetupGenAiConnector
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.emptyPrompts.setUpConnector.btn",
    defaultMessage: "Connect"
  }))))), connectorFlyoutOpen && /*#__PURE__*/_react.default.createElement(ConnectorFlyout, {
    featureId: _common.GenerativeAIForSearchPlaygroundConnectorFeatureId,
    onConnectorCreated: handleConnectorCreated,
    onClose: () => setConnectorFlyoutOpen(false)
  }));
};
exports.SetUpConnectorPanelForStartChat = SetUpConnectorPanelForStartChat;