"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuestionInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_HEIGHT = 200;
const QuestionInput = ({
  value,
  onChange,
  button,
  isDisabled
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleChange = (0, _react.useCallback)(e => {
    onChange(e.target.value);
    e.target.style.height = 'auto';
    e.target.style.height = `${e.target.scrollHeight}px`;
  }, [onChange]);
  const handleKeyDown = (0, _react.useCallback)(event => {
    if (event.key === _eui.keys.ENTER && !event.shiftKey) {
      var _event$currentTarget$;
      event.preventDefault();
      (_event$currentTarget$ = event.currentTarget.form) === null || _event$currentTarget$ === void 0 ? void 0 : _event$currentTarget$.requestSubmit();
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    className: "eui-scrollBar",
    style: {
      maxHeight: MAX_HEIGHT,
      lineHeight: euiTheme.size.l,
      padding: `${euiTheme.size.base} ${euiTheme.size.xxxxl} ${euiTheme.size.base} ${euiTheme.size.base}`
    },
    autoFocus: true,
    fullWidth: true,
    rows: 1,
    placeholder: _i18n.i18n.translate('xpack.searchPlayground.chat.questionInput.askQuestionPlaceholder', {
      defaultMessage: 'Ask a question'
    }),
    value: value,
    onKeyDown: handleKeyDown,
    onChange: handleChange,
    disabled: isDisabled,
    resize: "none"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      position: 'absolute',
      right: euiTheme.size.base,
      bottom: euiTheme.size.m
    }
  }, button));
};
exports.QuestionInput = QuestionInput;