"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditContextAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18nReact = require("@kbn/i18n-react");
var _edit_context_flyout = require("./edit_context_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditContextAction = () => {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const selectedIndices = watch('indices');
  const closeFlyout = () => setShowFlyout(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showFlyout && /*#__PURE__*/_react.default.createElement(_edit_context_flyout.EditContextFlyout, {
    onClose: closeFlyout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setShowFlyout(true),
    disabled: (selectedIndices === null || selectedIndices === void 0 ? void 0 : selectedIndices.length) === 0
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.actionButtonLabel",
    defaultMessage: "Edit context"
  })));
};
exports.EditContextAction = EditContextAction;