"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebooksPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _reactQuery = require("@tanstack/react-query");
var _console_view = require("./console_view");
var _get_error_message = require("./utils/get_error_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchNotebooksPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "queryClient", void 0);
  }
  setup(core) {
    this.queryClient = new _reactQuery.QueryClient({
      mutationCache: new _reactQuery.MutationCache({
        onError: error => {
          core.notifications.toasts.addError(error, {
            title: error.name,
            toastMessage: (0, _get_error_message.getErrorMessage)(error),
            toastLifeTimeMs: 1000
          });
        }
      }),
      queryCache: new _reactQuery.QueryCache({
        onError: error => {
          // 404s are often functionally okay and shouldn't show toasts by default
          if ((0, _get_error_message.getErrorCode)(error) === 404) {
            return;
          }
          if ((0, _get_error_message.isKibanaServerError)(error) && !error.skipToast) {
            core.notifications.toasts.addError(error, {
              title: error.name,
              toastMessage: (0, _get_error_message.getErrorMessage)(error),
              toastLifeTimeMs: 1000
            });
          }
        }
      })
    });
    return {};
  }
  start(core, deps) {
    var _deps$console;
    if ((_deps$console = deps.console) !== null && _deps$console !== void 0 && _deps$console.registerEmbeddedConsoleAlternateView) {
      deps.console.registerEmbeddedConsoleAlternateView((0, _console_view.notebooksConsoleView)(core, this.queryClient));
    }
    return {};
  }
  stop() {}
}
exports.SearchNotebooksPlugin = SearchNotebooksPlugin;