"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resultTitle = exports.resultMetaData = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TITLE_KEYS = ['title', 'name'];
const isRecord = source => {
  return typeof source === 'object' && source !== null;
};
function hasStringKey(source, key) {
  return typeof source[key] === 'string';
}
const resultTitle = result => {
  if (isRecord(result._source)) {
    for (const key of TITLE_KEYS) {
      if (hasStringKey(result._source, key)) {
        return result._source[key];
      }
    }
  }
  return undefined;
};
exports.resultTitle = resultTitle;
const resultMetaData = result => ({
  id: result._id,
  title: resultTitle(result)
});
exports.resultMetaData = resultMetaData;