"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Result = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _results_fields = require("./results_fields");
var _result_header = require("./result_header");
require("./result.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Result = ({
  metaData,
  fields
}) => {
  var _metaData$title;
  const [isExpanded, setIsExpanded] = (0, _react.useState)(false);
  const tooltipText = fields.length <= 3 ? _i18n.i18n.translate('searchIndexDocuments.result.expandTooltip.allVisible', {
    defaultMessage: 'All fields are visible'
  }) : isExpanded ? _i18n.i18n.translate('searchIndexDocuments.result.expandTooltip.showFewer', {
    defaultMessage: 'Show {amount} fewer fields',
    values: {
      amount: fields.length - 3
    }
  }) : _i18n.i18n.translate('searchIndexDocuments.result.expandTooltip.showMore', {
    defaultMessage: 'Show {amount} more fields',
    values: {
      amount: fields.length - 3
    }
  });
  const toolTipContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tooltipText);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    "data-test-subj": "search-index-documents-result"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_result_header.ResultHeader, {
    title: (_metaData$title = metaData.title) !== null && _metaData$title !== void 0 ? _metaData$title : _i18n.i18n.translate('searchIndexDocuments.result.title.id', {
      defaultMessage: 'Document id: {id}',
      values: {
        id: metaData.id
      }
    }),
    metaData: metaData
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_results_fields.ResultFields, {
    isExpanded: isExpanded,
    fields: isExpanded ? fields : fields.slice(0, 3)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "resultExpandColumn"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: toolTipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isExpanded ? 'fold' : 'unfold',
    color: "text",
    onClick: () => setIsExpanded(!isExpanded),
    "aria-label": tooltipText
  }))))));
};
exports.Result = Result;