"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsOverview = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocumentsOverview = ({
  accessControlSwitch,
  dataTelemetryIdPrefix,
  documentComponent,
  searchQueryCallback
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "enterpriseSearchDocumentsHeader",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('searchIndexDocuments.documents.title', {
    defaultMessage: 'Browse documents'
  })))), accessControlSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, accessControlSwitch), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-telemetry-id": `${dataTelemetryIdPrefix}-documents-searchDocuments`,
    placeholder: _i18n.i18n.translate('searchIndexDocuments.documents.searchField.placeholder', {
      defaultMessage: 'Search documents in this index'
    }),
    isClearable: true,
    onChange: event => searchQueryCallback(event.target.value),
    fullWidth: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, documentComponent)));
};
exports.DocumentsOverview = DocumentsOverview;