"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filteringPolicyToText = filteringPolicyToText;
exports.filteringRuleToText = filteringRuleToText;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const filteringRuleStringMap = {
  contains: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.contains', {
    defaultMessage: 'Contains'
  }),
  ends_with: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.endsWith', {
    defaultMessage: 'Ends with'
  }),
  equals: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.equals', {
    defaultMessage: 'Equals'
  }),
  ['>']: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.greaterThan', {
    defaultMessage: 'Greater than'
  }),
  ['<']: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.lessThan', {
    defaultMessage: 'Less than'
  }),
  regex: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.regEx', {
    defaultMessage: 'Regular expression'
  }),
  starts_with: _i18n.i18n.translate('searchConnectors.content.filteringRules.rules.startsWith', {
    defaultMessage: 'Starts with'
  })
};
function filteringRuleToText(filteringRule) {
  return filteringRuleStringMap[filteringRule];
}
const filteringPolicyStringMap = {
  exclude: _i18n.i18n.translate('searchConnectors.content.filteringRules.policy.exclude', {
    defaultMessage: 'Exclude'
  }),
  include: _i18n.i18n.translate('searchConnectors.content.filteringRules.policy.include', {
    defaultMessage: 'Include'
  })
};
function filteringPolicyToText(filteringPolicy) {
  return filteringPolicyStringMap[filteringPolicy];
}