"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFilteringDraft = void 0;
var _ = require("..");
var _fetch_connectors = require("./fetch_connectors");
var _connectors = require("../types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateFilteringDraft = async (client, connectorId, {
  advancedSnippet,
  filteringRules
}) => {
  const now = new Date().toISOString();
  const parsedAdvancedSnippet = advancedSnippet ? JSON.parse(advancedSnippet) : {};
  const parsedFilteringRules = filteringRules.map(filteringRule => ({
    ...filteringRule,
    created_at: filteringRule.created_at ? filteringRule.created_at : now,
    updated_at: now
  }));
  const draft = {
    advanced_snippet: {
      created_at: now,
      updated_at: now,
      value: parsedAdvancedSnippet
    },
    rules: parsedFilteringRules,
    validation: {
      errors: [],
      state: _connectors.FilteringValidationState.EDITED
    }
  };
  const connector = await (0, _fetch_connectors.fetchConnectorById)(client, connectorId);
  if (!connector) {
    throw new Error(`Could not find connector with id ${connectorId}`);
  }
  const result = await client.update({
    doc: {
      ...connector,
      filtering: [{
        ...connector.filtering[0],
        draft
      }]
    },
    id: connectorId,
    index: _.CONNECTORS_INDEX
  });
  return result.result === 'updated' ? draft : undefined;
};
exports.updateFilteringDraft = updateFilteringDraft;