"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchConnectorsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _connector_types = require("../common/lib/connector_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchConnectorsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "connectors", void 0);
    this.connectors = [];
  }
  setup({
    getStartServices,
    http
  }) {
    this.connectors = (0, _connector_types.getConnectorTypes)(http.staticAssets);
    return {
      getConnectorTypes: () => this.connectors
    };
  }
  start() {
    return {
      getConnectors: () => this.connectors
    };
  }
  stop() {}
}
exports.SearchConnectorsPlugin = SearchConnectorsPlugin;