"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorsDict = void 0;
var _doc_links = require("./doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// needs to be a function because, docLinks are only populated with actual
// documentation links in browser after SearchConnectorsPlugin starts
const getConnectorsDict = () => ({
  azure_blob_storage: {
    docsUrl: _doc_links.docLinks.connectorsAzureBlobStorage,
    externalAuthDocsUrl: 'https://learn.microsoft.com/azure/storage/common/authorize-data-access',
    externalDocsUrl: 'https://learn.microsoft.com/azure/storage/blobs/',
    platinumOnly: true
  },
  box: {
    docsUrl: _doc_links.docLinks.connectorsBox,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  confluence: {
    docsUrl: _doc_links.docLinks.connectorsConfluence,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  custom: {
    docsUrl: _doc_links.docLinks.connectors,
    externalAuthDocsUrl: '',
    externalDocsUrl: ''
  },
  dropbox: {
    docsUrl: _doc_links.docLinks.connectorsDropbox,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  github: {
    docsUrl: _doc_links.docLinks.connectorsGithub,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  gmail: {
    docsUrl: _doc_links.docLinks.connectorsGmail,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  google_cloud_storage: {
    docsUrl: _doc_links.docLinks.connectorsGoogleCloudStorage,
    externalAuthDocsUrl: 'https://cloud.google.com/storage/docs/authentication',
    externalDocsUrl: 'https://cloud.google.com/storage/docs',
    platinumOnly: true
  },
  google_drive: {
    docsUrl: _doc_links.docLinks.connectorsGoogleDrive,
    externalAuthDocsUrl: 'https://cloud.google.com/iam/docs/service-account-overview',
    externalDocsUrl: 'https://developers.google.com/drive',
    platinumOnly: true
  },
  jira: {
    docsUrl: _doc_links.docLinks.connectorsJira,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  microsoft_teams: {
    docsUrl: _doc_links.docLinks.connectorsTeams,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  mongodb: {
    docsUrl: _doc_links.docLinks.connectorsMongoDB,
    externalAuthDocsUrl: 'https://www.mongodb.com/docs/atlas/app-services/authentication/',
    externalDocsUrl: 'https://www.mongodb.com/docs/',
    platinumOnly: true
  },
  mssql: {
    docsUrl: _doc_links.docLinks.connectorsMicrosoftSQL,
    externalAuthDocsUrl: 'https://learn.microsoft.com/sql/relational-databases/security/authentication-access/getting-started-with-database-engine-permissions',
    externalDocsUrl: 'https://learn.microsoft.com/sql/',
    platinumOnly: true
  },
  mysql: {
    docsUrl: _doc_links.docLinks.connectorsMySQL,
    externalDocsUrl: 'https://dev.mysql.com/doc/',
    platinumOnly: true
  },
  network_drive: {
    docsUrl: _doc_links.docLinks.connectorsNetworkDrive,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  notion: {
    docsUrl: _doc_links.docLinks.connectorsNotion,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  onedrive: {
    docsUrl: _doc_links.docLinks.connectorsOneDrive,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  oracle: {
    docsUrl: _doc_links.docLinks.connectorsOracle,
    externalAuthDocsUrl: 'https://docs.oracle.com/en/database/oracle/oracle-database/19/dbseg/index.html',
    externalDocsUrl: 'https://docs.oracle.com/database/oracle/oracle-database/',
    platinumOnly: true
  },
  outlook: {
    docsUrl: _doc_links.docLinks.connectorsOutlook,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  postgresql: {
    docsUrl: _doc_links.docLinks.connectorsPostgreSQL,
    externalAuthDocsUrl: 'https://www.postgresql.org/docs/15/auth-methods.html',
    externalDocsUrl: 'https://www.postgresql.org/docs/',
    platinumOnly: true
  },
  redis: {
    docsUrl: _doc_links.docLinks.connectorsRedis,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  s3: {
    docsUrl: _doc_links.docLinks.connectorsS3,
    externalAuthDocsUrl: 'https://docs.aws.amazon.com/s3/index.html',
    externalDocsUrl: '',
    platinumOnly: true
  },
  salesforce: {
    docsUrl: _doc_links.docLinks.connectorsSalesforce,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  servicenow: {
    docsUrl: _doc_links.docLinks.connectorsServiceNow,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  sharepoint_online: {
    docsUrl: _doc_links.docLinks.connectorsSharepointOnline,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  sharepoint_server: {
    docsUrl: _doc_links.docLinks.connectorsSharepoint,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  slack: {
    docsUrl: _doc_links.docLinks.connectorsSlack,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  },
  zoom: {
    docsUrl: _doc_links.docLinks.connectorsZoom,
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    platinumOnly: true
  }
});
exports.getConnectorsDict = getConnectorsDict;