"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toPdf = toPdf;
var PDFJS = _interopRequireWildcard(require("pdfjs-dist/legacy/build/pdf.js"));
var _lodash = require("lodash");
var _event_logger = require("../../screenshots/event_logger");
var _pdf_maker = require("./pdf_maker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME: Once/if we have the ability to get page count directly from Chrome/puppeteer
// we should get rid of this lib.

/**
 * PDFs can be a single, long page or they can be multiple pages. For example:
 *
 * => When creating a PDF intended for print multiple PNGs will be spread out across pages
 * => When creating a PDF from a Canvas workpad, each page in the workpad will be placed on a separate page
 */

/**
 * Options that should be provided to a PDF screenshot request.
 */

/**
 * Final, formatted PDF result
 */

function getTimeRange(results) {
  const grouped = (0, _lodash.groupBy)(results.map(({
    timeRange
  }) => timeRange));
  const values = Object.values(grouped);
  if (values.length !== 1) {
    return;
  }
  return values[0][0];
}
async function toPdf(eventLogger, packageInfo, layout, {
  logo,
  title
}, {
  metrics,
  results
}) {
  let buffer;
  let pages;
  const shouldConvertPngsToPdf = layout.id !== 'print';
  if (shouldConvertPngsToPdf) {
    const timeRange = getTimeRange(results);
    try {
      ({
        buffer,
        pages
      } = await (0, _pdf_maker.pngsToPdf)({
        title: title ? `${title}${timeRange ? ` - ${timeRange}` : ''}` : undefined,
        results,
        layout,
        logo,
        packageInfo,
        eventLogger
      }));
      return {
        metrics: {
          ...(metrics !== null && metrics !== void 0 ? metrics : {}),
          pages
        },
        data: buffer,
        errors: results.flatMap(({
          error
        }) => error ? [error] : []),
        renderErrors: results.flatMap(({
          renderErrors
        }) => renderErrors !== null && renderErrors !== void 0 ? renderErrors : [])
      };
    } catch (error) {
      eventLogger.kbnLogger.error(`Could not generate the PDF buffer!`);
      eventLogger.error(error, _event_logger.Transactions.PDF);
      throw error;
    }
  } else {
    buffer = results[0].screenshots[0].data; // This buffer is already the PDF
    pages = await PDFJS.getDocument({
      data: buffer
    }).promise.then(doc => {
      const numPages = doc.numPages;
      doc.destroy();
      return numPages;
    });
  }
  return {
    metrics: {
      ...(metrics !== null && metrics !== void 0 ? metrics : {}),
      pages
    },
    data: buffer,
    errors: results.flatMap(({
      error
    }) => error ? [error] : []),
    renderErrors: results.flatMap(({
      renderErrors
    }) => renderErrors !== null && renderErrors !== void 0 ? renderErrors : [])
  };
}