"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _content_management = require("../../common/content_management");
var _cm_services = require("../../common/content_management/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedSearchStorage extends _contentManagementUtils.SOContentStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    super({
      savedObjectType: _content_management.SavedSearchType,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['title', 'sort', 'columns', 'description', 'grid', 'hideChart', 'isTextBasedQuery', 'usesAdHocDataView', 'kibanaSavedObjectMeta', 'viewMode', 'hideAggregatedPreview', 'rowHeight', 'headerRowHeight', 'timeRestore', 'timeRange', 'refreshInterval', 'rowsPerPage', 'breakdownField', 'sampleSize', 'visContext'],
      logger,
      throwOnResultValidationError
    });
  }
}
exports.SavedSearchStorage = SavedSearchStorage;