"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decorateConfig = void 0;
var _inject_tag_references = require("./inject_tag_references");
var _extract_tag_references = require("./extract_tag_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const decorateConfig = config => {
  config.mapping = {
    ...config.mapping,
    __tags: 'text'
  };
  const initialExtractReferences = config.extractReferences;
  const initialInjectReferences = config.injectReferences;
  config.injectReferences = (object, references) => {
    if (initialInjectReferences) {
      initialInjectReferences(object, references);
    }
    (0, _inject_tag_references.injectTagReferences)(object, references);
  };
  config.extractReferences = attrsAndRefs => {
    if (initialExtractReferences) {
      attrsAndRefs = initialExtractReferences(attrsAndRefs);
    }
    return (0, _extract_tag_references.extractTagReferences)(attrsAndRefs);
  };
};
exports.decorateConfig = decorateConfig;