"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _lib = require("../../../lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DeleteConfirmModal = ({
  isDeleting,
  onConfirm,
  onCancel,
  selectedObjects,
  allowedTypes,
  showPlainSpinner
}) => {
  const hiddenObjects = (0, _react.useMemo)(() => {
    return selectedObjects.filter(obj => obj.meta.hiddenType);
  }, [selectedObjects]);
  const deletableObjects = (0, _react.useMemo)(() => {
    return selectedObjects.filter(obj => !obj.meta.hiddenType).map(({
      type,
      id,
      meta,
      namespaces = []
    }) => {
      const {
        title = '',
        icon = 'apps'
      } = meta;
      const isShared = namespaces.length > 1 || namespaces.includes('*');
      return {
        type,
        id,
        icon,
        title,
        isShared
      };
    });
  }, [selectedObjects]);
  const sharedObjectsCount = (0, _react.useMemo)(() => {
    return deletableObjects.filter(obj => obj.isShared).length;
  }, [deletableObjects]);
  if (isDeleting) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xl"
    }));
  }
  // can't use `EuiConfirmModal` here as the confirm modal body is wrapped
  // inside a `<p>` element, causing UI glitches with the table.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    initialFocus: "soDeleteConfirmModalConfirmBtn",
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModalTitle",
    defaultMessage: "Delete saved objects"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, hiddenObjects.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "cannotDeleteObjectsConfirmWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.deleteConfirmModal.cannotDeleteCallout.title",
      defaultMessage: "Some objects have been excluded"
    }),
    iconType: "warning",
    color: "warning"
  }, hiddenObjects.length > 0 && /*#__PURE__*/_react.default.createElement("p", {
    css: (0, _react2.css)`
                    margin-block-end: 0 !important;
                  `
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteConfirmModal.cannotDeleteCallout.content",
    defaultMessage: "{objectCount, plural, one {# object is} other {# objects are}} hidden and cannot be deleted.",
    values: {
      objectCount: hiddenObjects.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), sharedObjectsCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "sharedObjectsWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.deleteConfirmModal.sharedObjectsCallout.title",
      defaultMessage: "{sharedObjectsCount, plural, one {# saved object is shared} other {# of your saved objects are shared}}",
      values: {
        sharedObjectsCount
      }
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteConfirmModal.sharedObjectsCallout.content",
    defaultMessage: "Shared objects are deleted from every space they are in."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.deleteSavedObjectsConfirmModalDescription",
    defaultMessage: "This action will delete the following saved objects:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: deletableObjects,
    columns: [{
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.typeColumnName', {
        defaultMessage: 'Type'
      }),
      width: '50px',
      render: (type, {
        icon
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: (0, _lib.getSavedObjectLabel)(type, allowedTypes)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: icon
      }))
    }, {
      field: 'id',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.idColumnName', {
        defaultMessage: 'ID'
      })
    }, {
      field: 'title',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.titleColumnName', {
        defaultMessage: 'Title'
      })
    }],
    pagination: true,
    sorting: false
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "confirmModalCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    id: "soDeleteConfirmModalConfirmBtn",
    fill: true,
    color: "danger",
    onClick: onConfirm,
    disabled: deletableObjects.length === 0,
    "data-test-subj": "confirmModalConfirmButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.deleteSavedObjectsConfirmModal.deleteButtonLabel",
    defaultMessage: "Delete {objectsCount, plural, one {# object} other {# objects}}",
    values: {
      objectsCount: deletableObjects.length
    }
  }))))))));
};
exports.DeleteConfirmModal = DeleteConfirmModal;