"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Inspect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const codeEditorAriaLabel = title => _i18n.i18n.translate('savedObjectsManagement.view.inspectCodeEditorAriaLabel', {
  defaultMessage: 'inspect { title }',
  values: {
    title
  }
});
const copyToClipboardLabel = _i18n.i18n.translate('savedObjectsManagement.view.copyToClipboardLabel', {
  defaultMessage: 'Copy to clipboard'
});
const Inspect = ({
  object
}) => {
  const title = object.meta.title || 'saved object';
  const objectAsJsonString = (0, _react.useMemo)(() => JSON.stringify((0, _lodash.omit)(object, 'meta'), null, 2), [object]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: objectAsJsonString
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": copyToClipboardLabel,
    size: "s",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy
  }, copyToClipboardLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    value: objectAsJsonString,
    "aria-label": codeEditorAriaLabel(title),
    options: {
      automaticLayout: false,
      fontSize: 12,
      lineNumbers: 'on',
      minimap: {
        enabled: false
      },
      overviewRulerBorder: false,
      readOnly: true,
      scrollbar: {
        alwaysConsumeMouseWheel: false
      },
      scrollBeyondLastLine: false,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      guides: {
        indentation: false
      }
    }
  })));
};
exports.Inspect = Inspect;