"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SavedObjectFinderUi = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/saved-objects-management-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedObjectFinderUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isComponentMounted", false);
    (0, _defineProperty2.default)(this, "debouncedFetch", (0, _lodash.debounce)(async query => {
      var _getTagFindReferences;
      const metaDataMap = this.getSavedObjectMetaDataMap();
      const {
        contentClient,
        uiSettings
      } = this.props.services;
      const {
        queryText,
        visibleTypes,
        selectedTags
      } = (0, _public.parseQuery)(query, Object.values(metaDataMap).map(metadata => ({
        name: metadata.type,
        namespaceType: 'single',
        hidden: false,
        displayName: metadata.name
      })));
      const includeTags = (_getTagFindReferences = (0, _public.getTagFindReferences)({
        selectedTags,
        taggingApi: this.props.services.savedObjectsTagging
      })) === null || _getTagFindReferences === void 0 ? void 0 : _getTagFindReferences.map(({
        id,
        type
      }) => id);
      const types = visibleTypes !== null && visibleTypes !== void 0 ? visibleTypes : Object.keys(metaDataMap);
      const response = await contentClient.mSearch({
        contentTypes: types.map(type => ({
          contentTypeId: type
        })),
        query: {
          text: queryText ? `${queryText}*` : undefined,
          ...(includeTags !== null && includeTags !== void 0 && includeTags.length ? {
            tags: {
              included: includeTags
            }
          } : {}),
          limit: uiSettings.get(_common.LISTING_LIMIT_SETTING) // TODO: support pagination,
        }
      });
      const savedObjects = response.hits.map(savedObject => {
        const {
          attributes: {
            name,
            title
          }
        } = savedObject;
        const titleToUse = typeof title === 'string' ? title : '';
        const nameToUse = name ? name : titleToUse;
        return {
          ...savedObject,
          version: savedObject.version,
          title: titleToUse,
          name: nameToUse,
          simple: savedObject
        };
      }).filter(savedObject => {
        const metaData = metaDataMap[savedObject.type];
        if (metaData.showSavedObject) {
          return metaData.showSavedObject(savedObject.simple);
        }
        return true;
      });
      if (!this.isComponentMounted) {
        return;
      }

      // We need this check to handle the case where search results come back in a different
      // order than they were sent out. Only load results for the most recent search.
      if (query.text === this.state.query.text) {
        this.setState({
          isFetchingItems: false,
          items: savedObjects
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "fetchItems", () => {
      this.setState({
        isFetchingItems: true
      }, this.debouncedFetch.bind(null, this.state.query));
    });
    this.state = {
      items: [],
      isFetchingItems: false,
      query: _eui.Query.parse('')
    };
  }
  componentWillUnmount() {
    this.isComponentMounted = false;
    this.debouncedFetch.cancel();
  }
  componentDidMount() {
    this.isComponentMounted = true;
    this.fetchItems();
  }
  getSavedObjectMetaDataMap() {
    return this.props.savedObjectMetaData.reduce((map, metaData) => ({
      ...map,
      [metaData.type]: metaData
    }), {});
  }
  render() {
    var _this$state$sort, _this$state$query;
    const {
      onChoose,
      savedObjectMetaData
    } = this.props;
    const taggingApi = this.props.services.savedObjectsTagging;
    const originalTagColumn = taggingApi === null || taggingApi === void 0 ? void 0 : taggingApi.ui.getTableColumnDefinition();
    const tagColumn = originalTagColumn ? {
      ...originalTagColumn,
      sortable: item => {
        var _originalTagColumn$so;
        return typeof originalTagColumn.sortable === 'function' ? (_originalTagColumn$so = originalTagColumn.sortable(item)) !== null && _originalTagColumn$so !== void 0 ? _originalTagColumn$so : '' : '';
      },
      ['data-test-subj']: 'savedObjectFinderTags'
    } : undefined;
    const typeColumn = savedObjectMetaData.length > 1 ? {
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsFinder.typeName', {
        defaultMessage: 'Type'
      }),
      width: '50px',
      align: 'center',
      description: _i18n.i18n.translate('savedObjectsFinder.typeDescription', {
        defaultMessage: 'Type of the saved object'
      }),
      sortable: ({
        type
      }) => {
        var _currentSavedObjectMe;
        const currentSavedObjectMetaData = savedObjectMetaData.find(metaData => metaData.type === type);
        return (_currentSavedObjectMe = currentSavedObjectMetaData === null || currentSavedObjectMetaData === void 0 ? void 0 : currentSavedObjectMetaData.name) !== null && _currentSavedObjectMe !== void 0 ? _currentSavedObjectMe : '';
      },
      'data-test-subj': 'savedObjectFinderType',
      render: (_, item) => {
        const currentSavedObjectMetaData = savedObjectMetaData.find(metaData => metaData.type === item.type);
        const iconType = (currentSavedObjectMetaData || {
          getIconForSavedObject: () => 'document'
        }).getIconForSavedObject(item.simple);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          content: currentSavedObjectMetaData.name
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          "aria-label": currentSavedObjectMetaData.name,
          type: iconType,
          size: "s",
          "data-test-subj": "objectType"
        }));
      }
    } : undefined;
    const columns = [...(typeColumn ? [typeColumn] : []), {
      field: 'title',
      name: _i18n.i18n.translate('savedObjectsFinder.titleName', {
        defaultMessage: 'Title'
      }),
      width: tagColumn ? '55%' : '100%',
      description: _i18n.i18n.translate('savedObjectsFinder.titleDescription', {
        defaultMessage: 'Title of the saved object'
      }),
      dataType: 'string',
      sortable: ({
        name
      }) => name === null || name === void 0 ? void 0 : name.toLowerCase(),
      'data-test-subj': 'savedObjectFinderTitle',
      render: (_, item) => {
        var _this$props$getToolti, _this$props;
        const currentSavedObjectMetaData = savedObjectMetaData.find(metaData => metaData.type === item.type);
        const fullName = currentSavedObjectMetaData.getTooltipForSavedObject ? currentSavedObjectMetaData.getTooltipForSavedObject(item.simple) : `${item.name} (${currentSavedObjectMetaData.name})`;
        const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onChoose ? () => {
            onChoose(item.id, item.type, fullName, item.simple);
          } : undefined,
          title: fullName,
          "data-test-subj": `savedObjectTitle${(item.title || '').split(' ').join('-')}`
        }, item.name);
        const tooltipText = (_this$props$getToolti = (_this$props = this.props).getTooltipText) === null || _this$props$getToolti === void 0 ? void 0 : _this$props$getToolti.call(_this$props, item);
        return tooltipText ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "left",
          content: tooltipText
        }, link) : link;
      }
    }, ...(tagColumn ? [tagColumn] : [])];
    const pagination = {
      initialPageSize: this.props.initialPageSize || this.props.fixedPageSize || 10,
      pageSizeOptions: [5, 10, 15, 25],
      showPerPageOptions: !this.props.fixedPageSize
    };
    const sorting = {
      sort: (_this$state$sort = this.state.sort) !== null && _this$state$sort !== void 0 ? _this$state$sort : {
        field: (_this$state$query = this.state.query) !== null && _this$state$query !== void 0 && _this$state$query.text ? '' : 'title',
        direction: 'asc'
      }
    };
    const typeFilter = {
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsFinder.filterButtonLabel', {
        defaultMessage: 'Types'
      }),
      multiSelect: 'or',
      options: this.props.savedObjectMetaData.map(metaData => ({
        value: metaData.type,
        name: metaData.name
      }))
    };
    const search = {
      onChange: ({
        query
      }) => {
        this.setState({
          query: query !== null && query !== void 0 ? query : _eui.Query.parse('')
        }, this.fetchItems);
      },
      box: {
        incremental: true,
        'data-test-subj': 'savedObjectFinderSearchInput'
      },
      filters: this.props.showFilter ? [...(savedObjectMetaData.length > 1 ? [typeFilter] : []), ...(taggingApi ? [taggingApi.ui.getSearchBarFilter({
        useName: true
      })] : [])] : undefined,
      toolsRight: this.props.children ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.children) : undefined,
      toolsLeft: this.props.leftChildren ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.leftChildren) : undefined
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, this.props.helpText ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, this.props.helpText)) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      loading: this.state.isFetchingItems,
      itemId: "id",
      items: this.state.items,
      columns: columns,
      "data-test-subj": "savedObjectsFinderTable",
      message: this.props.noItemsMessage,
      search: search,
      pagination: pagination,
      sorting: sorting,
      onTableChange: ({
        sort
      }) => {
        this.setState({
          sort
        });
      }
    })));
  }
}

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
exports.SavedObjectFinderUi = SavedObjectFinderUi;
(0, _defineProperty2.default)(SavedObjectFinderUi, "propTypes", {
  onChoose: _propTypes.default.func,
  noItemsMessage: _propTypes.default.node,
  savedObjectMetaData: _propTypes.default.array.isRequired,
  initialPageSize: _propTypes.default.oneOf([5, 10, 15, 25]),
  fixedPageSize: _propTypes.default.number,
  showFilter: _propTypes.default.bool
});
var _default = exports.default = SavedObjectFinderUi;