"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVersionedHeaderParam = exports.getVersionedContentString = exports.getPathParameters = exports.extractValidationSchemaFromVersionedHandler = exports.extractValidationSchemaFromRoute = void 0;
var _coreHttpServer = require("@kbn/core-http-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getPathParameters = path => {
  return Array.from(path.matchAll(/\{(.+?)\}/g)).reduce((acc, [_, key]) => {
    const optional = key.endsWith('?');
    acc[optional ? key.slice(0, key.length - 1) : key] = {
      optional
    };
    return acc;
  }, {});
};
exports.getPathParameters = getPathParameters;
const extractValidationSchemaFromVersionedHandler = handler => {
  if (handler.options.validate === false) return undefined;
  if (typeof handler.options.validate === 'function') return handler.options.validate();
  return handler.options.validate;
};
exports.extractValidationSchemaFromVersionedHandler = extractValidationSchemaFromVersionedHandler;
const getVersionedContentString = version => {
  return `application/json; Elastic-Api-Version=${version}`;
};
exports.getVersionedContentString = getVersionedContentString;
const extractValidationSchemaFromRoute = route => {
  if (!route.validationSchemas) return undefined;
  return (0, _coreHttpServer.getRequestValidation)(route.validationSchemas);
};
exports.extractValidationSchemaFromRoute = extractValidationSchemaFromRoute;
const getVersionedHeaderParam = (defaultVersion, versions) => ({
  in: 'header',
  name: 'elastic-api-version',
  schema: {
    type: 'string',
    enum: versions,
    default: defaultVersion
  }
});
exports.getVersionedHeaderParam = getVersionedHeaderParam;