"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processMap = exports.processAny = void 0;
Object.defineProperty(exports, "processObject", {
  enumerable: true,
  get: function () {
    return _object.processObject;
  }
});
exports.processString = exports.processRecord = void 0;
var _configSchema = require("@kbn/config-schema");
var _parse = require("../../parse");
var _utils = require("./utils");
var _object = require("./object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  META_FIELD_X_OAS_MAX_LENGTH,
  META_FIELD_X_OAS_MIN_LENGTH,
  META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES
} = _configSchema.metaFields;
const processString = schema => {
  if (META_FIELD_X_OAS_MIN_LENGTH in schema) {
    schema.minLength = schema[META_FIELD_X_OAS_MIN_LENGTH];
    (0, _utils.deleteField)(schema, META_FIELD_X_OAS_MIN_LENGTH);
  }
  if (META_FIELD_X_OAS_MAX_LENGTH in schema) {
    schema.maxLength = schema[META_FIELD_X_OAS_MAX_LENGTH];
    (0, _utils.deleteField)(schema, META_FIELD_X_OAS_MAX_LENGTH);
  }
};
exports.processString = processString;
const processAdditionalProperties = (ctx, schema) => {
  if (META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES in schema) {
    const fn = schema[META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES];
    const {
      result: additionalSchema
    } = (0, _parse.parse)({
      ctx,
      schema: fn()
    });
    schema.additionalProperties = additionalSchema;
    (0, _utils.deleteField)(schema, META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES);
  } else {
    schema.additionalProperties = true;
  }
};
const processRecord = (ctx, schema) => {
  schema.type = 'object';
  processAdditionalProperties(ctx, schema);
  if (schema.additionalProperties) {
    schema.additionalProperties = ctx.processRef(schema.additionalProperties);
  }
};
exports.processRecord = processRecord;
const processMap = (ctx, schema) => {
  schema.type = 'object';
  processAdditionalProperties(ctx, schema);
  if (schema.additionalProperties) {
    schema.additionalProperties = ctx.processRef(schema.additionalProperties);
  }
};
exports.processMap = processMap;
const processAny = schema => {
  (0, _utils.processDeprecated)(schema);
  (0, _utils.stripBadDefault)(schema);
};
exports.processAny = processAny;