"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parse = exports.joi2JsonInternal = void 0;
var _joiToJson = _interopRequireDefault(require("joi-to-json"));
var _post_process_mutations = require("./post_process_mutations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const joi2JsonInternal = schema => {
  return (0, _joiToJson.default)(schema, 'open-api');
};
exports.joi2JsonInternal = joi2JsonInternal;
const parse = ({
  schema,
  ctx = (0, _post_process_mutations.createCtx)()
}) => {
  const parsed = joi2JsonInternal(schema);
  (0, _post_process_mutations.postProcessMutations)({
    schema: parsed,
    ctx
  });
  const result = ctx.processRef(parsed);
  return {
    shared: ctx.sharedSchemas,
    result
  };
};
exports.parse = parse;