"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OasConverter = void 0;
var _kbn_config_schema = require("./kbn_config_schema");
var _catch_all = require("./catch_all");
function _classPrivateMethodInitSpec(obj, privateSet) { _checkPrivateRedeclaration(obj, privateSet); privateSet.add(obj); }
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _converters = /*#__PURE__*/new WeakMap();
var _sharedSchemas = /*#__PURE__*/new WeakMap();
var _OasConverter_brand = /*#__PURE__*/new WeakSet();
class OasConverter {
  constructor() {
    _classPrivateMethodInitSpec(this, _OasConverter_brand);
    _classPrivateFieldInitSpec(this, _converters, [_kbn_config_schema.kbnConfigSchemaConverter, _catch_all.catchAllConverter]);
    _classPrivateFieldInitSpec(this, _sharedSchemas, new Map());
  }
  convert(schema) {
    const {
      schema: oasSchema,
      shared
    } = _assertClassBrand(_OasConverter_brand, this, _getConverter).call(this, schema).convert(schema);
    _assertClassBrand(_OasConverter_brand, this, _addComponents).call(this, shared);
    return oasSchema;
  }
  convertPathParameters(schema, pathParameters) {
    const {
      params,
      shared
    } = _assertClassBrand(_OasConverter_brand, this, _getConverter).call(this, schema).convertPathParameters(schema, pathParameters);
    _assertClassBrand(_OasConverter_brand, this, _addComponents).call(this, shared);
    return params;
  }
  convertQuery(schema) {
    const {
      query,
      shared
    } = _assertClassBrand(_OasConverter_brand, this, _getConverter).call(this, schema).convertQuery(schema);
    _assertClassBrand(_OasConverter_brand, this, _addComponents).call(this, shared);
    return query;
  }
  getSchemaComponents() {
    return {
      schemas: Object.fromEntries(_classPrivateFieldGet(_sharedSchemas, this).entries())
    };
  }
}
exports.OasConverter = OasConverter;
function _getConverter(schema) {
  return _classPrivateFieldGet(_converters, this).find(c => c.is(schema));
}
function _addComponents(components) {
  Object.entries(components).forEach(([id, schema]) => {
    _classPrivateFieldGet(_sharedSchemas, this).set(id, schema);
  });
}