"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePathParameters = exports.isReferenceObject = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const trimTrailingStar = str => str.replace(/\*$/, '');
const validatePathParameters = (pathParameters, schemaKeys) => {
  if (pathParameters.length !== schemaKeys.length) {
    throw new Error(`Schema expects [${schemaKeys.join(', ')}], but path contains [${pathParameters.join(', ')}]`);
  }
  for (let pathParameter of pathParameters) {
    pathParameter = trimTrailingStar(pathParameter);
    if (!schemaKeys.includes(pathParameter)) {
      throw new Error(`Path expects key "${pathParameter}" from schema but it was not found. Existing schema keys are: ${schemaKeys.join(', ')}`);
    }
  }
};
exports.validatePathParameters = validatePathParameters;
const isReferenceObject = schema => {
  return typeof schema === 'object' && schema !== null && '$ref' in schema;
};
exports.isReferenceObject = isReferenceObject;