"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFullRedirectAppUrl = getFullRedirectAppUrl;
var _url = require("url");
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFullRedirectAppUrl(config, serverInfo, spaceId, forceNow) {
  const {
    kibanaServer: {
      protocol,
      hostname,
      port
    }
  } = config;
  const path = (0, _reportingCommon.buildKibanaPath)({
    basePath: serverInfo.basePath,
    spaceId,
    appPath: _reportingCommon.REPORTING_REDIRECT_APP
  });
  return (0, _url.format)({
    protocol: protocol !== null && protocol !== void 0 ? protocol : serverInfo.protocol,
    hostname: hostname !== null && hostname !== void 0 ? hostname : serverInfo.hostname,
    port: port !== null && port !== void 0 ? port : serverInfo.port,
    pathname: path,
    query: forceNow ? {
      forceNow
    } : undefined
  });
}