"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _deprecations = require("./internal/deprecations/deprecations");
var _diagnostic = require("./internal/diagnostic");
var _csv_searchsource_immediate = require("./internal/generate/csv_searchsource_immediate");
var _generate_from_jobparams = require("./internal/generate/generate_from_jobparams");
var _jobs = require("./internal/management/jobs");
var _generate_from_jobparams2 = require("./public/generate_from_jobparams");
var _jobs2 = require("./public/jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoutes(reporting, logger) {
  (0, _deprecations.registerDeprecationsRoutes)(reporting, logger);
  (0, _diagnostic.registerDiagnosticRoutes)(reporting, logger);
  (0, _generate_from_jobparams.registerGenerationRoutesInternal)(reporting, logger);
  (0, _jobs.registerJobInfoRoutesInternal)(reporting);
  (0, _generate_from_jobparams2.registerGenerationRoutesPublic)(reporting, logger);
  (0, _jobs2.registerJobInfoRoutesPublic)(reporting);

  // (deprecated) allow users to download CSV without generating a report
  const config = reporting.getConfig();
  if (config.csv.enablePanelActionDownload) {
    (0, _csv_searchsource_immediate.registerGenerateCsvFromSavedObjectImmediate)(reporting, logger);
  }
}