"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var React = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _reportingPublic = require("@kbn/reporting-public");
var _ = require(".");
var _default_status_context = require("../lib/default_status_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function mountManagementSection(coreStart, license$, dataService, shareService, config, apiClient, params) {
  const services = {
    http: coreStart.http,
    application: coreStart.application,
    uiSettings: coreStart.uiSettings,
    docLinks: coreStart.docLinks,
    data: dataService,
    share: shareService
  };
  (0, _reactDom.render)( /*#__PURE__*/React.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$: params.theme$
    }
  }, /*#__PURE__*/React.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/React.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/React.createElement(_reportingPublic.InternalApiClientProvider, {
    apiClient: apiClient,
    http: services.http
  }, /*#__PURE__*/React.createElement(_default_status_context.PolicyStatusContextProvider, {
    config: config
  }, /*#__PURE__*/React.createElement(_.ReportListing, {
    apiClient: apiClient,
    toasts: coreStart.notifications.toasts,
    license$: license$,
    config: config,
    redirect: coreStart.application.navigateToApp,
    navigateToUrl: coreStart.application.navigateToUrl,
    urlService: shareService.url
  })))))), params.element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(params.element);
  };
}