"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportListingDefault = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _report_listing_table = require("../report_listing_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Used in non-stateful (Serverless)
 * Does not render controls for features only applicable in Stateful
 */
const ReportListingDefault = props => {
  const {
    apiClient,
    capabilities,
    config,
    navigateToUrl,
    toasts,
    urlService,
    ...listingProps
  } = props;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "reportingPageHeader",
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.reportstitle",
      defaultMessage: "Reports"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.reports.subtitle",
      defaultMessage: "Get reports generated in Kibana applications."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  }), /*#__PURE__*/_react.default.createElement(_report_listing_table.ReportListingTable, (0, _extends2.default)({}, listingProps, {
    apiClient: apiClient,
    capabilities: capabilities,
    config: config,
    toasts: toasts,
    navigateToUrl: navigateToUrl,
    urlService: urlService
  })));
};
exports.ReportListingDefault = ReportListingDefault;