"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_SETTINGS_SEARCH_INCLUDE_FROZEN = exports.UI_SETTINGS_DATEFORMAT_TZ = exports.UI_SETTINGS_CUSTOM_PDF_LOGO = exports.REPORT_TABLE_ROW_ID = exports.REPORT_TABLE_ID = exports.REPORTING_REDIRECT_LOCATOR_STORE_KEY = exports.REPORTING_REDIRECT_APP = exports.REPORTING_MANAGEMENT_HOME = exports.LICENSE_TYPE_TRIAL = exports.LICENSE_TYPE_PLATINUM = exports.LICENSE_TYPE_GOLD = exports.LICENSE_TYPE_ENTERPRISE = exports.LICENSE_TYPE_CLOUD_STANDARD = exports.LICENSE_TYPE_BASIC = exports.JOB_STATUS = exports.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = exports.ILM_POLICY_NAME = exports.ALLOWED_JOB_CONTENT_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ALLOWED_JOB_CONTENT_TYPES = exports.ALLOWED_JOB_CONTENT_TYPES = ['application/json', 'application/pdf', 'text/csv', 'image/png', 'text/plain'];

/*
 * UI Settings
 */

const UI_SETTINGS_SEARCH_INCLUDE_FROZEN = exports.UI_SETTINGS_SEARCH_INCLUDE_FROZEN = 'search:includeFrozen';
const UI_SETTINGS_CUSTOM_PDF_LOGO = exports.UI_SETTINGS_CUSTOM_PDF_LOGO = 'xpackReporting:customPdfLogo';
const UI_SETTINGS_DATEFORMAT_TZ = exports.UI_SETTINGS_DATEFORMAT_TZ = 'dateFormat:tz';

/*
 * Licenses
 */

const LICENSE_TYPE_TRIAL = exports.LICENSE_TYPE_TRIAL = 'trial';
const LICENSE_TYPE_BASIC = exports.LICENSE_TYPE_BASIC = 'basic';
const LICENSE_TYPE_CLOUD_STANDARD = exports.LICENSE_TYPE_CLOUD_STANDARD = 'standard';
const LICENSE_TYPE_GOLD = exports.LICENSE_TYPE_GOLD = 'gold';
const LICENSE_TYPE_PLATINUM = exports.LICENSE_TYPE_PLATINUM = 'platinum';
const LICENSE_TYPE_ENTERPRISE = exports.LICENSE_TYPE_ENTERPRISE = 'enterprise';

/*
 * Notifications
 */

const JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = exports.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY = 'xpack.reporting.jobCompletionNotifications';

/*
 * Client-side paths
 */

// Redirection URL used to load app state for screenshotting
const REPORTING_REDIRECT_APP = exports.REPORTING_REDIRECT_APP = '/app/reportingRedirect';
const REPORTING_REDIRECT_LOCATOR_STORE_KEY = exports.REPORTING_REDIRECT_LOCATOR_STORE_KEY = '__REPORTING_REDIRECT_LOCATOR_STORE_KEY__';

// Management UI route
const REPORTING_MANAGEMENT_HOME = exports.REPORTING_MANAGEMENT_HOME = '/app/management/insightsAndAlerting/reporting';

/*
 * ILM
 */

const ILM_POLICY_NAME = exports.ILM_POLICY_NAME = 'kibana-reporting';

/*
 * JobStatus:
 *  - Begins as 'pending'
 *  - Changes to 'processing` when the job is claimed
 *  - Then 'completed' | 'failed' when execution is done
 * If the job needs a retry, it reverts back to 'pending'.
 */
let JOB_STATUS = exports.JOB_STATUS = /*#__PURE__*/function (JOB_STATUS) {
  JOB_STATUS["PENDING"] = "pending";
  JOB_STATUS["PROCESSING"] = "processing";
  JOB_STATUS["COMPLETED"] = "completed";
  JOB_STATUS["FAILED"] = "failed";
  JOB_STATUS["WARNINGS"] = "completed_with_warnings";
  return JOB_STATUS;
}({});
/*
 * Test Subjects
 */
// Management app subjects
const REPORT_TABLE_ID = exports.REPORT_TABLE_ID = 'reportJobListing';
const REPORT_TABLE_ROW_ID = exports.REPORT_TABLE_ROW_ID = 'reportJobRow';