"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClustersUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _breadcrumb = require("./application/services/breadcrumb");
var _documentation = require("./application/services/documentation");
var _http = require("./application/services/http");
var _ui_metric = require("./application/services/ui_metric");
var _notification = require("./application/services/notification");
var _redirect = require("./application/services/redirect");
var _locator = require("./locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class RemoteClustersUIPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "canUseApiKeyTrustModel", false);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
    this.initializerContext = initializerContext;
  }
  setup({
    notifications: {
      toasts
    },
    http,
    getStartServices
  }, {
    management,
    usageCollection,
    cloud,
    share
  }) {
    const {
      ui: {
        enabled: isRemoteClustersUiEnabled
      }
    } = this.initializerContext.config.get();
    if (isRemoteClustersUiEnabled) {
      const esSection = management.sections.section.data;
      esSection.registerApp({
        id: 'remote_clusters',
        title: _i18n.i18n.translate('xpack.remoteClusters.appTitle', {
          defaultMessage: 'Remote Clusters'
        }),
        order: 7,
        mount: async ({
          element,
          setBreadcrumbs,
          history
        }) => {
          var _cloud$baseUrl;
          const [core] = await getStartServices();
          const {
            chrome: {
              docTitle
            },
            docLinks,
            fatalErrors,
            executionContext
          } = core;
          docTitle.change(_constants.PLUGIN.getI18nName());

          // Initialize services
          (0, _breadcrumb.init)(setBreadcrumbs);
          (0, _documentation.init)(docLinks);
          (0, _ui_metric.init)(usageCollection);
          (0, _notification.init)(toasts, fatalErrors);
          (0, _http.init)(http);
          const isCloudEnabled = Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled);
          const cloudBaseUrl = (_cloud$baseUrl = cloud === null || cloud === void 0 ? void 0 : cloud.baseUrl) !== null && _cloud$baseUrl !== void 0 ? _cloud$baseUrl : '';
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          const unmountAppCallback = await renderApp(element, {
            isCloudEnabled,
            cloudBaseUrl,
            executionContext,
            canUseAPIKeyTrustModel: this.canUseApiKeyTrustModel
          }, history, core);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
      share.url.locators.create(new _locator.RemoteClustersLocatorDefinition({
        managementAppLocator: management.locator
      }));
    }
    return {
      isUiEnabled: isRemoteClustersUiEnabled
    };
  }
  start({
    application
  }, {
    licensing
  }) {
    const {
      ui: {
        enabled: isRemoteClustersUiEnabled
      }
    } = this.initializerContext.config.get();
    if (isRemoteClustersUiEnabled) {
      (0, _redirect.init)(application.navigateToApp);
    }
    this.licensingSubscription = licensing.license$.subscribe(next => {
      this.canUseApiKeyTrustModel = next.hasAtLeast('enterprise');
    });
  }
  stop() {
    var _this$licensingSubscr;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
  }
}
exports.RemoteClustersUIPlugin = RemoteClustersUIPlugin;