"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityModel = SecurityModel;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SecurityModel({
  securityModel
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "authenticationTypeLabel",
    size: "s"
  }, (0, _constants.getSecurityModel)(securityModel))), securityModel !== 'api_key' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "authenticationTypeWarning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "iInCircle",
    color: "subdued",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterList.table.authTypeWarningMessage",
      defaultMessage: "If you need more fine-grained permissions on your remote cluster, you can now use API keys instead of certificates as authentication mechanism."
    })
  })));
}