"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterWizard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _components = require("../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONFIGURE_CONNECTION = 1;
const SETUP_TRUST = 2;
const RemoteClusterWizard = ({
  saveRemoteClusterConfig,
  onCancel,
  isSaving,
  addClusterError
}) => {
  const [formState, setFormState] = (0, _react.useState)();
  const [currentStep, setCurrentStep] = (0, _react.useState)(CONFIGURE_CONNECTION);

  // If there was an error saving the cluster, we need
  // to send the user back to the first step.
  (0, _react.useEffect)(() => {
    if (addClusterError) {
      setCurrentStep(CONFIGURE_CONNECTION);
    }
  }, [addClusterError, setCurrentStep]);
  const stepDefinitions = (0, _react.useMemo)(() => [{
    step: CONFIGURE_CONNECTION,
    title: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.addConnectionInfoLabel', {
      defaultMessage: 'Add connection information'
    }),
    status: currentStep === CONFIGURE_CONNECTION ? 'current' : 'complete',
    onClick: () => setCurrentStep(CONFIGURE_CONNECTION)
  }, {
    step: SETUP_TRUST,
    title: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.setupTrustLabel', {
      defaultMessage: 'Establish trust'
    }),
    status: currentStep === SETUP_TRUST ? 'current' : 'incomplete',
    disabled: !formState,
    onClick: () => setCurrentStep(SETUP_TRUST)
  }], [currentStep, formState, setCurrentStep]);

  // Upon finalizing configuring the connection, we need to temporarily store the
  // cluster configuration so that we can persist it when the user completes the
  // trust step.
  const completeConfigStep = clusterConfig => {
    setFormState(clusterConfig);
    setCurrentStep(SETUP_TRUST);
  };
  const completeTrustStep = () => {
    saveRemoteClusterConfig(formState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: stepDefinitions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === CONFIGURE_CONNECTION ? 'block' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterForm, {
    save: completeConfigStep,
    cancel: onCancel,
    saveError: addClusterError
  })), currentStep === SETUP_TRUST && /*#__PURE__*/_react.default.createElement(_components.RemoteClusterSetupTrust, {
    onBack: () => setCurrentStep(CONFIGURE_CONNECTION),
    onSubmit: completeTrustStep,
    isSaving: isSaving
  }));
};
exports.RemoteClusterWizard = RemoteClusterWizard;