"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterAdd = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _breadcrumb = require("../../services/breadcrumb");
var _components = require("../components");
var _wizard_form = require("./wizard_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RemoteClusterAdd extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "save", clusterConfig => {
      this.props.addCluster(clusterConfig);
    });
    (0, _defineProperty2.default)(this, "redirectToList", () => {
      const {
        history,
        route: {
          location: {
            search
          }
        }
      } = (0, _services.getRouter)();
      const {
        redirect: redirectUrl
      } = (0, _shared_imports.extractQueryParams)(search);
      if (redirectUrl) {
        const decodedRedirect = decodeURIComponent(redirectUrl);
        (0, _services.redirect)(decodedRedirect);
      } else {
        history.push('/list');
      }
    });
  }
  componentDidMount() {
    (0, _breadcrumb.setBreadcrumbs)('add');
  }
  componentWillUnmount() {
    // Clean up after ourselves.
    this.props.clearAddClusterErrors();
  }
  render() {
    const {
      isAddingCluster,
      addClusterError
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      "data-test-subj": "remote-clusters-add"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterPageTitle, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.addTitle",
        defaultMessage: "Add remote cluster"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClustersDescription",
        defaultMessage: "Create a connection from this cluster to other Elasticsearch clusters."
      })
    }), /*#__PURE__*/_react.default.createElement(_wizard_form.RemoteClusterWizard, {
      saveRemoteClusterConfig: this.save,
      onCancel: this.redirectToList,
      isSaving: isAddingCluster,
      addClusterError: addClusterError
    })));
  }
}
exports.RemoteClusterAdd = RemoteClusterAdd;
(0, _defineProperty2.default)(RemoteClusterAdd, "propTypes", {
  addCluster: _propTypes.default.func,
  isAddingCluster: _propTypes.default.bool,
  addClusterError: _propTypes.default.object,
  clearAddClusterErrors: _propTypes.default.func
});