"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmTrustSetupModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmTrustSetupModal = ({
  closeModal,
  onSubmit
}) => {
  const [hasSetupTrust, setHasSetupTrust] = (0, _react.useState)(false);
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'modalForm'
  });
  const checkBoxId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'checkBoxId'
  });
  const onFormSubmit = e => {
    e.preventDefault();
    closeModal();
    onSubmit();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.modal.title",
    defaultMessage: "Confirm your configuration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.body",
    defaultMessage: "Have you set up trust to connect to your remote cluster?"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: modalFormId,
    component: "form",
    onSubmit: onFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkBoxId,
    label: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.modal.checkbox', {
      defaultMessage: 'Yes, I have setup trust'
    }),
    labelProps: {
      'data-test-subj': 'remoteClusterTrustCheckboxLabel'
    },
    checked: hasSetupTrust,
    onChange: () => setHasSetupTrust(!hasSetupTrust),
    "data-test-subj": "remoteClusterTrustCheckbox"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.modal.cancelButton",
    defaultMessage: "No, go back"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: modalFormId,
    disabled: !hasSetupTrust,
    "data-test-subj": "remoteClusterTrustSubmitButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.modal.createCluster",
    defaultMessage: "Add remote cluster"
  }))));
};
exports.ConfirmTrustSetupModal = ConfirmTrustSetupModal;