"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCluster = void 0;
var _validate_name = require("./validate_name");
var _constants = require("../../../../../../common/constants");
var _validate_seeds = require("./validate_seeds");
var _validate_proxy = require("./validate_proxy");
var _validate_cloud_url = require("./validate_cloud_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateCluster = (fields, isCloudEnabled) => {
  const {
    name,
    seeds = [],
    mode,
    proxyAddress,
    cloudRemoteAddress
  } = fields;
  return {
    name: (0, _validate_name.validateName)(name),
    seeds: mode === _constants.SNIFF_MODE ? (0, _validate_seeds.validateSeeds)(seeds) : null,
    proxyAddress: mode === _constants.PROXY_MODE ? (0, _validate_proxy.validateProxy)(proxyAddress) : null,
    cloudRemoteAddress: isCloudEnabled ? (0, _validate_cloud_url.validateCloudRemoteAddress)(cloudRemoteAddress) : null
  };
};
exports.validateCluster = validateCluster;