"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCloudRemoteAddress = exports.isCloudAdvancedOptionsEnabled = exports.i18nTexts = exports.convertCloudRemoteAddressToProxyConnection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _validate_address = require("./validate_address");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = exports.i18nTexts = {
  urlEmpty: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.cloudDeploymentForm.remoteAddressRequiredError",
    defaultMessage: "A remote address is required."
  }),
  urlInvalid: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.cloudDeploymentForm.remoteAddressInvalidError",
    defaultMessage: "Remote address is invalid."
  })
};
const CLOUD_DEFAULT_PROXY_PORT = '9400';
const EMPTY_PROXY_VALUES = {
  proxyAddress: '',
  serverName: ''
};
const PROTOCOL_REGEX = new RegExp(/^https?:\/\//);
const DEFAULT_SOCKET_CONNECTIONS = 18;
const isCloudAdvancedOptionsEnabled = cluster => {
  // The toggle is switched off by default
  if (!cluster) {
    return false;
  }
  const {
    proxyAddress,
    serverName,
    proxySocketConnections
  } = cluster;
  if (!proxyAddress) {
    return false;
  }
  const proxyAddressWithoutPort = (proxyAddress !== null && proxyAddress !== void 0 ? proxyAddress : '').split(':')[0];
  return proxyAddressWithoutPort !== serverName || proxySocketConnections != null && proxySocketConnections !== DEFAULT_SOCKET_CONNECTIONS;
};
exports.isCloudAdvancedOptionsEnabled = isCloudAdvancedOptionsEnabled;
const formatUrl = url => {
  var _url;
  url = ((_url = url) !== null && _url !== void 0 ? _url : '').trim().toLowerCase();
  // delete http(s):// protocol string if any
  url = url.replace(PROTOCOL_REGEX, '');
  return url;
};
const convertCloudRemoteAddressToProxyConnection = url => {
  url = formatUrl(url);
  if (!url || !(0, _validate_address.isAddressValid)(url)) {
    return EMPTY_PROXY_VALUES;
  }
  const host = url.split(':')[0];
  const port = url.split(':')[1];
  const proxyAddress = port ? url : `${host}:${CLOUD_DEFAULT_PROXY_PORT}`;
  return {
    proxyAddress,
    serverName: host
  };
};
exports.convertCloudRemoteAddressToProxyConnection = convertCloudRemoteAddressToProxyConnection;
const validateCloudRemoteAddress = url => {
  if (!url) {
    return i18nTexts.urlEmpty;
  }
  url = formatUrl(url);
  if (!(0, _validate_address.isAddressValid)(url)) {
    return i18nTexts.urlInvalid;
  }
  return null;
};
exports.validateCloudRemoteAddress = validateCloudRemoteAddress;