"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityModel = exports.SNIFF_MODE = exports.PROXY_MODE = exports.PLUGIN = exports.MAJOR_VERSION = exports.API_BASE_PATH = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const basicLicense = 'basic';
const PLUGIN = exports.PLUGIN = {
  // Remote Clusters are used in both CCS and CCR, and CCS is available for all licenses.
  minimumLicenseType: basicLicense,
  getI18nName: () => {
    return _i18n.i18n.translate('xpack.remoteClusters.appName', {
      defaultMessage: 'Remote Clusters'
    });
  }
};
const MAJOR_VERSION = exports.MAJOR_VERSION = '8.5.0';
const API_BASE_PATH = exports.API_BASE_PATH = '/api/remote_clusters';
const SNIFF_MODE = exports.SNIFF_MODE = 'sniff';
const PROXY_MODE = exports.PROXY_MODE = 'proxy';
const getSecurityModel = type => {
  if (type === 'certificate') {
    return _i18n.i18n.translate('xpack.remoteClusters.securityModelCert', {
      defaultMessage: 'Certificate'
    });
  }
  if (type === 'api_key') {
    return _i18n.i18n.translate('xpack.remoteClusters.securityModelApiKey', {
      defaultMessage: 'API key'
    });
  }
  return type;
};
exports.getSecurityModel = getSecurityModel;