"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageExplorerView = StorageExplorerView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _primary_profiling_search_bar = require("../../components/profiling_app_page_template/primary_profiling_search_bar");
var _use_async = require("../../hooks/use_async");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _data_breakdown = require("./data_breakdown");
var _distinct_probabilistic_values_warning = require("./distinct_probabilistic_values_warning");
var _host_breakdown = require("./host_breakdown");
var _index_lifecycle_phase_select = require("./index_lifecycle_phase_select");
var _summary = require("./summary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StorageExplorerView() {
  var _storageExplorerSumma;
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    indexLifecyclePhase
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [selectedTab, setSelectedTab] = (0, _react.useState)('host_breakdown');
  const {
    services: {
      fetchStorageExplorerSummary
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const storageExplorerSummaryState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchStorageExplorerSummary({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery,
      indexLifecyclePhase
    });
  }, [fetchStorageExplorerSummary, timeRange.inSeconds.start, timeRange.inSeconds.end, kuery, indexLifecyclePhase]);
  const totalNumberOfDistinctProbabilisticValues = ((_storageExplorerSumma = storageExplorerSummaryState.data) === null || _storageExplorerSumma === void 0 ? void 0 : _storageExplorerSumma.totalNumberOfDistinctProbabilisticValues) || 0;
  const hasDistinctProbabilisticValues = totalNumberOfDistinctProbabilisticValues > 1;
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    hideSearchBar: true,
    pageTitle: _i18n.i18n.translate('xpack.profiling.storageExplorer.title', {
      defaultMessage: 'Storage Explorer'
    }),
    showBetaBadge: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_primary_profiling_search_bar.PrimaryProfilingSearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      justifyContent: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_index_lifecycle_phase_select.IndexLifecyclePhaseSelect, null)))), hasDistinctProbabilisticValues && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_distinct_probabilistic_values_warning.DistinctProbabilisticValuesWarning, {
    totalNumberOfDistinctProbabilisticValues: totalNumberOfDistinctProbabilisticValues
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_summary.Summary, {
    data: storageExplorerSummaryState.data,
    isLoading: storageExplorerSummaryState.status === _use_async.AsyncStatus.Loading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => {
      setSelectedTab('host_breakdown');
    },
    isSelected: selectedTab === 'host_breakdown'
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.tabs.hostBreakdown', {
    defaultMessage: 'Host agent breakdown'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => {
      setSelectedTab('data_breakdown');
    },
    isSelected: selectedTab === 'data_breakdown'
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.tabs.dataBreakdown', {
    defaultMessage: 'Data breakdown'
  })))), selectedTab === 'host_breakdown' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_host_breakdown.HostBreakdown, {
    hasDistinctProbabilisticValues: hasDistinctProbabilisticValues
  })) : null, selectedTab === 'data_breakdown' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_data_breakdown.DataBreakdown, null)) : null));
}