"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostBreakdown = HostBreakdown;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _hosts_table = require("./hosts_table");
var _host_breakdown_chart = require("./host_breakdown_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HostBreakdown({
  hasDistinctProbabilisticValues
}) {
  var _storageExplorerHostD, _storageExplorerHostD2;
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/storage-explorer');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    indexLifecyclePhase
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchStorageExplorerHostStorageDetails
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const storageExplorerHostDetailsState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchStorageExplorerHostStorageDetails({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery,
      indexLifecyclePhase
    });
  }, [fetchStorageExplorerHostStorageDetails, timeRange.inSeconds.start, timeRange.inSeconds.end, kuery, indexLifecyclePhase]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.storageExplorer.hostBreakdown.title', {
    defaultMessage: 'Host agent breakdown'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.profiling.storageExplorer.hostBreakdown.title.hint', {
      defaultMessage: 'This graph shows the combined values of Universal Profiling samples and metrics. host.name[host.id].'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "questionInCircle",
    style: {
      marginLeft: 4
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "xl"
  }, storageExplorerHostDetailsState, {
    style: {
      height: 400
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_host_breakdown_chart.HostBreakdownChart, {
    data: (_storageExplorerHostD = storageExplorerHostDetailsState.data) === null || _storageExplorerHostD === void 0 ? void 0 : _storageExplorerHostD.hostDetailsTimeseries
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hosts_table.HostsTable, {
    data: (_storageExplorerHostD2 = storageExplorerHostDetailsState.data) === null || _storageExplorerHostD2 === void 0 ? void 0 : _storageExplorerHostD2.hostDetails,
    hasDistinctProbabilisticValues: hasDistinctProbabilisticValues
  }))))));
}