"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialTopNFunctionsView = DifferentialTopNFunctionsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _frames_summary = require("../../../components/frames_summary");
var _differential_topn_functions_grid = require("../../../components/differential_topn_functions_grid");
var _normalization_menu = require("../../../components/normalization_menu");
var _primary_and_comparison_search_bar = require("../../../components/primary_and_comparison_search_bar");
var _use_async = require("../../../hooks/use_async");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DifferentialTopNFunctionsView() {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/functions/differential');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    sortDirection,
    sortField,
    comparisonKuery,
    normalizationMode,
    comparisonRangeFrom,
    comparisonRangeTo,
    baseline = 1,
    comparison = 1,
    pageIndex = 0,
    comparisonSortDirection,
    comparisonSortField
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: comparisonRangeFrom,
    rangeTo: comparisonRangeTo,
    optional: true
  });
  const totalSeconds = timeRange.inSeconds.end - timeRange.inSeconds.start;
  const totalComparisonSeconds = comparisonTimeRange.inSeconds.end - comparisonTimeRange.inSeconds.start;
  const comparisonTime = totalSeconds / totalComparisonSeconds;
  const baselineTime = 1;
  const normalizationOptions = {
    baselineScale: baseline,
    baselineTime,
    comparisonScale: comparison,
    comparisonTime
  };
  const {
    services: {
      fetchTopNFunctions
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchTopNFunctions({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      startIndex: 0,
      endIndex: 100000,
      kuery
    });
  }, [fetchTopNFunctions, timeRange.start, timeRange.end, kuery]);
  const comparisonState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    if (!comparisonTimeRange.start || !comparisonTimeRange.end) {
      return undefined;
    }
    return fetchTopNFunctions({
      http,
      timeFrom: new Date(comparisonTimeRange.start).getTime(),
      timeTo: new Date(comparisonTimeRange.end).getTime(),
      startIndex: 0,
      endIndex: 100000,
      kuery: comparisonKuery
    });
  }, [comparisonTimeRange.start, comparisonTimeRange.end, fetchTopNFunctions, comparisonKuery]);
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function onChangeNormalizationMode(nextNormalizationMode, options) {
    profilingRouter.push(routePath, {
      path: routePath,
      query: nextNormalizationMode === _normalization_menu.NormalizationMode.Scale ? {
        ...query,
        baseline: options.baselineScale,
        comparison: options.comparisonScale,
        normalizationMode: nextNormalizationMode
      } : {
        ...query,
        normalizationMode: nextNormalizationMode
      }
    });
  }
  const isNormalizedByTime = normalizationMode === _normalization_menu.NormalizationMode.Time;
  function handleOnFrameClick(functionName) {
    profilingRouter.push('/flamegraphs/flamegraph', {
      path: {},
      query: {
        ...query,
        searchText: functionName
      }
    });
  }
  function handlePageChange(nextPage) {
    profilingRouter.push('/functions/differential', {
      path: {},
      query: {
        ...query,
        pageIndex: nextPage
      }
    });
  }
  function handleOnSort(sorting) {
    profilingRouter.push('/functions/differential', {
      path: {},
      query: {
        ...query,
        ...sorting
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_primary_and_comparison_search_bar.PrimaryAndComparisonSearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_normalization_menu.NormalizationMenu, {
    mode: normalizationMode,
    options: normalizationOptions,
    onChange: onChangeNormalizationMode
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_frames_summary.FramesSummary, {
    isLoading: state.status === _use_async.AsyncStatus.Loading || comparisonState.status === _use_async.AsyncStatus.Loading,
    baseValue: state.data ? {
      totalCount: state.data.selfCPU,
      scaleFactor: isNormalizedByTime ? baselineTime : baseline,
      totalAnnualCO2Kgs: state.data.totalAnnualCO2Kgs,
      totalAnnualCostUSD: state.data.totalAnnualCostUSD
    } : undefined,
    comparisonValue: comparisonState.data ? {
      totalCount: comparisonState.data.selfCPU,
      scaleFactor: isNormalizedByTime ? comparisonTime : comparison,
      totalAnnualCO2Kgs: comparisonState.data.totalAnnualCO2Kgs,
      totalAnnualCostUSD: comparisonState.data.totalAnnualCostUSD
    } : undefined
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, comparisonState.status === _use_async.AsyncStatus.Loading ? comparisonState : state, {
    size: "xl",
    alignTop: true
  }), /*#__PURE__*/_react.default.createElement(_differential_topn_functions_grid.DifferentialTopNFunctionsGrid, {
    base: state.data,
    baselineScaleFactor: isNormalizedByTime ? comparisonTime : comparison,
    comparison: comparisonState.data,
    comparisonScaleFactor: isNormalizedByTime ? baselineTime : baseline,
    comparisonSortDirection: comparisonSortDirection,
    comparisonSortField: comparisonSortField,
    comparisonTotalSeconds: totalComparisonSeconds,
    onChangePage: handlePageChange,
    onChangeSort: handleOnSort,
    onFrameClick: handleOnFrameClick,
    pageIndex: pageIndex,
    sortDirection: sortDirection,
    sortField: sortField,
    totalSeconds: totalSeconds
  })))));
}