"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingPlugin = void 0;
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _register_embeddables = require("./embeddables/register_embeddables");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ProfilingPlugin {
  setup(coreSetup, pluginsSetup) {
    // Register an application into the side navigation menu
    const links = [{
      id: 'stacktraces',
      title: _i18n.i18n.translate('xpack.profiling.navigation.stacktracesLinkLabel', {
        defaultMessage: 'Stacktraces'
      }),
      path: '/stacktraces'
    }, {
      id: 'flamegraphs',
      title: _i18n.i18n.translate('xpack.profiling.navigation.flameGraphsLinkLabel', {
        defaultMessage: 'Flamegraphs'
      }),
      path: '/flamegraphs'
    }, {
      id: 'functions',
      title: _i18n.i18n.translate('xpack.profiling.navigation.functionsLinkLabel', {
        defaultMessage: 'Functions'
      }),
      path: '/functions'
    }];
    const kuerySubject = new _rxjs.BehaviorSubject('');
    const section$ = (0, _rxjs.combineLatest)([(0, _rxjs.from)(coreSetup.getStartServices()), kuerySubject]).pipe((0, _rxjs.map)(([[coreStart], kuery]) => {
      if (coreStart.application.capabilities.profiling.show) {
        const sections = [{
          label: _i18n.i18n.translate('xpack.profiling.navigation.sectionLabel', {
            defaultMessage: 'Universal Profiling'
          }),
          entries: links.map(link => {
            return {
              app: _deeplinksObservability.OBLT_PROFILING_APP_ID,
              label: link.title,
              path: `${link.path}?kuery=${kuery !== null && kuery !== void 0 ? kuery : ''}`,
              matchPath: path => {
                return path.startsWith(link.path);
              }
            };
          }),
          sortKey: 700
        }];
        return sections;
      }
      return [];
    }));
    pluginsSetup.observabilityShared.navigation.registerSections(section$);
    const profilingFetchServices = (0, _services.getServices)();
    coreSetup.application.register({
      id: _deeplinksObservability.OBLT_PROFILING_APP_ID,
      title: 'Universal Profiling',
      euiIconType: 'logoObservability',
      appRoute: '/app/profiling',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      deepLinks: links,
      async mount({
        element,
        history,
        theme$,
        setHeaderActionMenu
      }) {
        const [coreStart, pluginsStart] = await coreSetup.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app')));
        function pushKueryToSubject(location) {
          var _query$get;
          const query = new URLSearchParams(location.search);
          kuerySubject.next((_query$get = query.get('kuery')) !== null && _query$get !== void 0 ? _query$get : '');
        }
        pushKueryToSubject(history.location);
        history.listen(pushKueryToSubject);
        const unmount = renderApp({
          profilingFetchServices,
          coreStart,
          coreSetup,
          pluginsStart,
          pluginsSetup,
          history,
          theme$,
          setHeaderActionMenu
        }, element);
        return () => {
          unmount();
          kuerySubject.next('');
        };
      }
    });
    const getProfilingEmbeddableDependencies = async () => {
      const [coreStart, pluginsStart] = await coreSetup.getStartServices();
      return {
        coreStart,
        coreSetup,
        pluginsStart,
        pluginsSetup,
        profilingFetchServices
      };
    };
    (0, _register_embeddables.registerEmbeddables)(pluginsSetup.embeddable, getProfilingEmbeddableDependencies);
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.ProfilingPlugin = ProfilingPlugin;