"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFunctions = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _async_embeddable_component = require("../async_embeddable_component");
var _profiling_embeddable_provider = require("../profiling_embeddable_provider");
var _embeddable_functions_grid = require("./embeddable_functions_grid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableFunctions extends _public.Embeddable {
  constructor(deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", _public2.EMBEDDABLE_FUNCTIONS);
    (0, _defineProperty2.default)(this, "_domNode", void 0);
    this.deps = deps;
  }
  render(domNode) {
    this._domNode = domNode;
    const {
      data,
      isLoading,
      rangeFrom,
      rangeTo
    } = this.input;
    const totalSeconds = (rangeTo - rangeFrom) / 1000;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_profiling_embeddable_provider.ProfilingEmbeddableProvider, {
      deps: this.deps
    }, /*#__PURE__*/_react.default.createElement(_async_embeddable_component.AsyncEmbeddableComponent, {
      isLoading: isLoading
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_embeddable_functions_grid.EmbeddableFunctionsGrid, {
      data: data,
      totalSeconds: totalSeconds
    })))), domNode);
  }
  destroy() {
    if (this._domNode) {
      (0, _reactDom.unmountComponentAtNode)(this._domNode);
    }
  }
  reload() {
    if (this._domNode) {
      this.render(this._domNode);
    }
  }
}
exports.EmbeddableFunctions = EmbeddableFunctions;