"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.providers = exports.pluginServices = exports.getStubPluginServices = void 0;
var _create = require("./create");
var _plugin_services = require("./plugin_services.story");
var _ = require("..");
var _capabilities = require("./capabilities/capabilities.story");
var _data_views = require("./data_views/data_views.story");
var _labs = require("./labs/labs.story");
var _ui_actions = require("./ui_actions/ui_actions.stub");
var _content_management = require("./content_management/content_management.stub");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providers = exports.providers = {
  contentManagement: new _create.PluginServiceProvider(_content_management.contentManagementServiceFactory),
  capabilities: new _create.PluginServiceProvider(_capabilities.capabilitiesServiceFactory),
  labs: new _create.PluginServiceProvider(_labs.labsServiceFactory),
  dataViews: new _create.PluginServiceProvider(_data_views.dataViewsServiceFactory),
  uiActions: new _create.PluginServiceProvider(_ui_actions.uiActionsServiceFactory)
};
const pluginServices = exports.pluginServices = new _create.PluginServices();
const getStubPluginServices = () => {
  pluginServices.setRegistry(_plugin_services.registry.start({}));
  return {
    ContextProvider: pluginServices.getContextProvider(),
    labsService: pluginServices.getServices().labs,
    registerExpressionsLanguage: _.registerExpressionsLanguage
  };
};
exports.getStubPluginServices = getStubPluginServices;