"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginServiceProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A collection of `PluginServiceProvider` objects, keyed by the `Services` API generic.
 *
 * The `Services` generic determines the shape of all service APIs being produced.
 * The `StartParameters` generic determines what parameters are expected to
 * start the service.
 */

/**
 * An object which uses a given factory to start, stop or provide a service.
 *
 * The `Service` generic determines the shape of the API being produced.
 * The `StartParameters` generic determines what parameters are expected to
 * start the service.
 */
class PluginServiceProvider {
  constructor(factory, requiredServices) {
    (0, _defineProperty2.default)(this, "factory", void 0);
    (0, _defineProperty2.default)(this, "_requiredServices", void 0);
    (0, _defineProperty2.default)(this, "context", /*#__PURE__*/(0, _react.createContext)(null));
    (0, _defineProperty2.default)(this, "pluginService", null);
    (0, _defineProperty2.default)(this, "Provider", ({
      children
    }) => {
      return /*#__PURE__*/_react.default.createElement(this.context.Provider, {
        value: this.getService()
      }, children);
    });
    this.factory = factory;
    this._requiredServices = requiredServices;
    this.context.displayName = 'PluginServiceContext';
  }

  /**
   * Getter that will enforce proper setup throughout the class.
   */
  getService() {
    if (!this.pluginService) {
      throw new Error('Service not started');
    }
    return this.pluginService;
  }

  /**
   * Start the service.
   *
   * @param params Parameters used to start the service.
   */
  start(params, requiredServices) {
    this.pluginService = this.factory(params, requiredServices);
  }

  /**
   * Returns a function for providing a Context hook for the service.
   */
  getServiceReactHook() {
    return () => {
      const service = (0, _react.useContext)(this.context);
      if (!service) {
        throw new Error('Provider is not set up correctly');
      }
      return service;
    };
  }

  /**
   * Stop the service.
   */
  stop() {
    this.pluginService = null;
  }
  get requiredServices() {
    var _this$_requiredServic;
    return (_this$_requiredServic = this._requiredServices) !== null && _this$_requiredServic !== void 0 ? _this$_requiredServic : [];
  }
}
exports.PluginServiceProvider = PluginServiceProvider;