"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardDrilldownConfigStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dashboardDrilldownConfigStrings = exports.dashboardDrilldownConfigStrings = {
  component: {
    getUseCurrentFiltersLabel: () => _i18n.i18n.translate('presentationUtil.dashboardDrilldownConfig.components.useCurrentFiltersLabel', {
      defaultMessage: 'Use filters and query from origin dashboard'
    }),
    getUseCurrentDateRange: () => _i18n.i18n.translate('presentationUtil.dashboardDrilldownConfig.components.useCurrentDateRange', {
      defaultMessage: 'Use date range from origin dashboard'
    }),
    getOpenInNewTab: () => _i18n.i18n.translate('presentationUtil.dashboardDrilldownConfig.components.openInNewTab', {
      defaultMessage: 'Open dashboard in new tab'
    })
  }
};