"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _project_list_item = require("./project_list_item");
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  List: strings
} = _i18n.LabsStrings.Components;
const EmptyList = ({
  solutions
}) => {
  let title = strings.getNoProjectsMessage();
  if ((solutions === null || solutions === void 0 ? void 0 : solutions.length) === 1) {
    const solution = solutions[0];
    switch (solution) {
      case 'dashboard':
        title = strings.getNoProjectsInSolutionMessage('Dashboard');
      case 'canvas':
        title = strings.getNoProjectsInSolutionMessage('Canvas');
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title
  });
};
const ProjectList = props => {
  const {
    solutions,
    projects,
    onStatusChange
  } = props;
  const items = Object.values(projects).map(project => {
    if (!project.isDisplayed) {
      return null;
    }

    // Filter out any panels that don't match the solutions filter, (if provided).
    if (solutions && !solutions.some(solution => project.solutions.includes(solution))) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("li", {
      key: project.id
    }, /*#__PURE__*/_react.default.createElement(_project_list_item.ProjectListItem, {
      project: project,
      onStatusChange: onStatusChange
    }));
  }).filter(item => item !== null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, items.length > 0 ? /*#__PURE__*/_react.default.createElement("ul", null, items) : /*#__PURE__*/_react.default.createElement(EmptyList, {
    solutions: solutions
  }));
};
exports.ProjectList = ProjectList;