"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeFilter = FieldTypeFilter;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function FieldTypeFilter({
  availableFieldTypes,
  onFieldTypesChange,
  setFocusToSearch,
  fieldTypesValue,
  buttonProps
}) {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const handleFilterButtonClicked = () => {
    setPopoverOpen(!isPopoverOpen);
  };
  const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, buttonProps, {
    "data-test-subj": "toggleFieldFilterButton",
    iconType: "arrowDown",
    isSelected: fieldTypesValue.length > 0,
    numFilters: 0,
    hasActiveFilters: fieldTypesValue.length > 0,
    numActiveFilters: fieldTypesValue.length,
    onClick: handleFilterButtonClicked
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "presentationUtil.fieldSearch.fieldFilterButtonLabel",
    defaultMessage: "Filter by type"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    panelPaddingSize: "none",
    display: "block",
    isOpen: isPopoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
    },
    fullWidth: true,
    input: buttonContent,
    focusTrapProps: {
      returnFocus: false,
      // we will be manually returning the focus to the search
      onDeactivation: setFocusToSearch
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: availableFieldTypes.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: type,
      icon: fieldTypesValue.includes(type) ? 'check' : 'empty',
      "data-test-subj": `typeFilter-${type}`,
      onClick: () => {
        if (fieldTypesValue.includes(type)) {
          onFieldTypesChange(fieldTypesValue.filter(f => f !== type));
        } else {
          onFieldTypesChange([...fieldTypesValue, type]);
        }
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: type,
      label: type
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, type))))
  })));
}