"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./_presentation_panel.scss");
var _eui = require("@elastic/eui");
var _panelLoader = require("@kbn/panel-loader");
var _std = require("@kbn/std");
var _react = _interopRequireDefault(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _kibana_services = require("../kibana_services");
var _presentation_panel_error = require("./presentation_panel_error");
var _presentation_panel_strings = require("./presentation_panel_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const PresentationPanel = props => {
  const {
    Component,
    ...passThroughProps
  } = props;
  const {
    loading,
    value,
    error
  } = (0, _useAsync.default)(async () => {
    const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
    const modulePromise = await Promise.resolve().then(() => _interopRequireWildcard(require('./presentation_panel_internal')));
    const componentPromise = (0, _std.isPromise)(Component) ? Component : Promise.resolve(Component);
    const [, unwrappedComponent, panelModule] = await Promise.all([startServicesPromise, componentPromise, modulePromise]);
    const Panel = panelModule.PresentationPanelInternal;
    return {
      Panel,
      unwrappedComponent
    };
    // Ancestry chain is expected to use 'key' attribute to reset DOM and state
    // when unwrappedComponent needs to be re-loaded
  }, []);
  if (error || !loading && (!(value !== null && value !== void 0 && value.Panel) || !(value !== null && value !== void 0 && value.unwrappedComponent))) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      className: "eui-fullHeight embPanel__error",
      "data-test-subj": "embeddableError",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_presentation_panel_error.PresentationPanelError, {
      error: error !== null && error !== void 0 ? error : new Error((0, _presentation_panel_strings.getErrorLoadingPanel)())
    }));
  }
  if (loading || !(value !== null && value !== void 0 && value.Panel) || !(value !== null && value !== void 0 && value.unwrappedComponent)) return /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, {
    showShadow: props.showShadow,
    showBorder: props.showBorder,
    dataTestSubj: "embeddablePanelLoadingIndicator"
  });
  return /*#__PURE__*/_react.default.createElement(value.Panel, (0, _extends2.default)({
    Component: value.unwrappedComponent
  }, passThroughProps));
};
exports.PresentationPanel = PresentationPanel;