"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePresentationPanelTitleClickHandler = exports.PresentationPanelTitle = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _presentation_panel_strings = require("../presentation_panel_strings");
var _customize_panel_action = require("../../panel_actions/customize_panel_action");
var _open_customize_panel = require("../../panel_actions/customize_panel_action/open_customize_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createDocumentMouseMoveListener = (0, _lodash.once)(() => (0, _rxjs.fromEvent)(document, 'mousemove'));
const createDocumentMouseUpListener = (0, _lodash.once)(() => (0, _rxjs.fromEvent)(document, 'mouseup'));
const usePresentationPanelTitleClickHandler = titleElmRef => {
  const onClick = (0, _react.useRef)(null);
  const [initialized, setInitialized] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (titleElmRef) {
      const mouseup = createDocumentMouseUpListener();
      const mousemove = createDocumentMouseMoveListener();
      const mousedown = (0, _rxjs.fromEvent)(titleElmRef, 'mousedown');
      const keydown = (0, _rxjs.fromEvent)(titleElmRef, 'keydown');
      const mousedragExclusiveClick$ = mousedown.pipe((0, _rxjs.mergeMap)(function (md) {
        // create reference for when mouse is down
        const startX = md.offsetX;
        const startY = md.offsetY;
        return mousemove.pipe((0, _rxjs.map)(function (mm) {
          return {
            dragged: startX !== mm.clientX && startY !== mm.clientY
          };
        })).pipe((0, _rxjs.takeUntil)(mouseup), (0, _rxjs.takeLast)(1)).pipe((0, _rxjs.defaultIfEmpty)({
          dragged: false
        }));
      })).pipe((0, _rxjs.repeatWhen)(() => mousedown));
      onClick.current = (0, _rxjs.race)(keydown.pipe((0, _rxjs.takeWhile)(kd => kd.key === 'Enter')).pipe((0, _rxjs.map)(() => ({
        dragged: false
      }))), mousedragExclusiveClick$);
      setInitialized(true);
    }
  }, [titleElmRef]);
  return initialized ? onClick.current : null;
};
exports.usePresentationPanelTitleClickHandler = usePresentationPanelTitleClickHandler;
const PresentationPanelTitle = ({
  api,
  viewMode,
  hideTitle,
  panelTitle,
  panelDescription
}) => {
  const [panelTitleElmRef, setPanelTitleElmRef] = (0, _react.useState)(null);
  const panelTitleElement = (0, _react.useMemo)(() => {
    if (hideTitle) return null;
    const titleClassNames = (0, _classnames.default)('embPanel__titleText', {
      // eslint-disable-next-line @typescript-eslint/naming-convention
      embPanel__placeholderTitleText: !panelTitle
    });
    if (viewMode !== 'edit' || !(0, _customize_panel_action.isApiCompatibleWithCustomizePanelAction)(api)) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: titleClassNames
      }, panelTitle);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      ref: setPanelTitleElmRef,
      className: titleClassNames,
      "aria-label": (0, _presentation_panel_strings.getEditTitleAriaLabel)(panelTitle),
      "data-test-subj": 'embeddablePanelTitleLink'
    }, panelTitle || _presentation_panel_strings.placeholderTitle);
  }, [setPanelTitleElmRef, hideTitle, panelTitle, viewMode, api]);
  const onClick = usePresentationPanelTitleClickHandler(panelTitleElmRef);
  (0, _react.useEffect)(() => {
    const panelTitleClickSubscription = onClick === null || onClick === void 0 ? void 0 : onClick.subscribe(function onClickHandler({
      dragged
    }) {
      if (!dragged) {
        (0, _open_customize_panel.openCustomizePanelFlyout)({
          api: api,
          focusOnTitle: true
        });
      }
    });
    return () => panelTitleClickSubscription === null || panelTitleClickSubscription === void 0 ? void 0 : panelTitleClickSubscription.unsubscribe();
  }, [api, onClick]);
  const describedPanelTitleElement = (0, _react.useMemo)(() => {
    if (!panelDescription) {
      if (hideTitle) return null;
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "embeddablePanelTitleInner",
        className: "embPanel__titleInner"
      }, panelTitleElement);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: !hideTitle ? panelTitle || undefined : undefined,
      content: panelDescription,
      delay: "regular",
      position: "top",
      anchorClassName: "embPanel__titleTooltipAnchor",
      anchorProps: {
        'data-test-subj': 'embeddablePanelTooltipAnchor'
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "embeddablePanelTitleInner",
      className: "embPanel__titleInner"
    }, !hideTitle ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, panelTitleElement, "\xA0") : null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle",
      color: "subdued",
      "data-test-subj": "embeddablePanelTitleDescriptionIcon"
    })));
  }, [hideTitle, panelDescription, panelTitle, panelTitleElement]);
  return describedPanelTitleElement;
};
exports.PresentationPanelTitle = PresentationPanelTitle;