"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelHeader = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _presentation_panel_strings = require("../presentation_panel_strings");
var _presentation_panel_context_menu = require("./presentation_panel_context_menu");
var _presentation_panel_title = require("./presentation_panel_title");
var _use_presentation_panel_header_actions = require("./use_presentation_panel_header_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PresentationPanelHeader = ({
  api,
  index,
  viewMode,
  headerId,
  getActions,
  hideTitle,
  panelTitle,
  panelDescription,
  actionPredicate,
  showBadges = true,
  showNotifications = true
}) => {
  const {
    notificationElements,
    badgeElements
  } = (0, _use_presentation_panel_header_actions.usePresentationPanelHeaderActions)(showNotifications, showBadges, api, getActions);
  const showPanelBar = !hideTitle || panelDescription || viewMode !== 'view' || badgeElements.length > 0 || notificationElements.length > 0;
  const ariaLabel = (0, _presentation_panel_strings.getAriaLabelForTitle)(showPanelBar ? panelTitle : undefined);
  const ariaLabelElement = /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", {
    id: headerId
  }, ariaLabel));
  const headerClasses = (0, _classnames.default)('embPanel__header', {
    'embPanel__header--floater': !showPanelBar
  });
  const titleClasses = (0, _classnames.default)('embPanel__title', {
    'embPanel--dragHandle': viewMode === 'edit'
  });
  const contextMenuElement = /*#__PURE__*/_react.default.createElement(_presentation_panel_context_menu.PresentationPanelContextMenu, {
    index,
    api,
    getActions,
    actionPredicate
  });
  if (!showPanelBar) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `embeddablePanelHeading`,
      className: headerClasses
    }, contextMenuElement, ariaLabelElement);
  }
  return /*#__PURE__*/_react.default.createElement("figcaption", {
    className: headerClasses,
    "data-test-subj": `embeddablePanelHeading-${(panelTitle || '').replace(/\s/g, '')}`
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dashboardPanelTitle",
    className: titleClasses
  }, ariaLabelElement, /*#__PURE__*/_react.default.createElement(_presentation_panel_title.PresentationPanelTitle, {
    api: api,
    viewMode: viewMode,
    hideTitle: hideTitle,
    panelTitle: panelTitle,
    panelDescription: panelDescription
  }), showBadges && badgeElements), showNotifications && notificationElements, contextMenuElement);
};
exports.PresentationPanelHeader = PresentationPanelHeader;