"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelContextMenu = void 0;
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../../kibana_services");
var _panel_actions = require("../../panel_actions");
var _presentation_panel_strings = require("../presentation_panel_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PresentationPanelContextMenu = ({
  api,
  index,
  getActions,
  actionPredicate
}) => {
  const [menuPanelsLoading, setMenuPanelsLoading] = (0, _react.useState)(false);
  const [contextMenuActions, setContextMenuActions] = (0, _react.useState)([]);
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(undefined);
  const [contextMenuPanels, setContextMenuPanels] = (0, _react.useState)([]);
  const [title, parentViewMode] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api.panelTitle,
  /**
   * View mode changes often have the biggest influence over which actions will be compatible,
   * so we build and update all actions when the view mode changes. This is temporary, as these
   * actions should eventually all be Frequent Compatibility Change Actions which can track their
   * own dependencies.
   */
  (0, _presentationPublishing.getViewModeSubject)(api));
  (0, _react.useEffect)(() => {
    /**
     * isContextMenuOpen starts as undefined which allows this use effect to run on mount. This
     * is required so that showNotification is calculated on mount.
     */
    if (isContextMenuOpen === false || !api) return;
    setMenuPanelsLoading(true);
    let canceled = false;
    (async _api$disabledActionId => {
      /**
       * Build and update all actions
       */
      let compatibleActions = await (async _await$uiActions$getT => {
        if (getActions) return await getActions(_panel_actions.CONTEXT_MENU_TRIGGER, {
          embeddable: api
        });
        return (_await$uiActions$getT = await _kibana_services.uiActions.getTriggerCompatibleActions(_panel_actions.CONTEXT_MENU_TRIGGER, {
          embeddable: api
        })) !== null && _await$uiActions$getT !== void 0 ? _await$uiActions$getT : [];
      })();
      if (canceled) return;
      const disabledActions = (_api$disabledActionId = api.disabledActionIds) === null || _api$disabledActionId === void 0 ? void 0 : _api$disabledActionId.value;
      if (disabledActions) {
        compatibleActions = compatibleActions.filter(action => disabledActions.indexOf(action.id) === -1);
      }
      if (actionPredicate) {
        compatibleActions = compatibleActions.filter(({
          id
        }) => actionPredicate(id));
      }
      compatibleActions.sort(({
        order: orderA
      }, {
        order: orderB
      }) => (orderB || 0) - (orderA || 0));

      /**
       * Build context menu panel from actions
       */
      const panels = await (0, _public.buildContextMenuForActions)({
        actions: compatibleActions.map(action => ({
          action,
          context: {
            embeddable: api
          },
          trigger: _panel_actions.contextMenuTrigger
        })),
        closeMenu: () => setIsContextMenuOpen(false)
      });
      if (canceled) return;
      setMenuPanelsLoading(false);
      setContextMenuActions(compatibleActions);
      setContextMenuPanels(panels);
    })();
    return () => {
      canceled = true;
    };
  }, [actionPredicate, api, getActions, isContextMenuOpen, parentViewMode]);
  const showNotification = (0, _react.useMemo)(() => contextMenuActions.some(action => action.showNotification), [contextMenuActions]);
  const contextMenuClasses = (0, _classnames.default)({
    // eslint-disable-next-line @typescript-eslint/naming-convention
    embPanel__optionsMenuPopover: true,
    'embPanel__optionsMenuPopover-notification': showNotification
  });
  const ContextMenuButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    className: "embPanel__optionsMenuButton",
    "data-test-subj": "embeddablePanelToggleMenuIcon",
    "aria-label": (0, _presentation_panel_strings.getContextMenuAriaLabel)(title, index),
    onClick: () => setIsContextMenuOpen(isOpen => !isOpen),
    iconType: 'boxesHorizontal'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    repositionOnScroll: true,
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    button: ContextMenuButton,
    isOpen: isContextMenuOpen,
    className: contextMenuClasses,
    closePopover: () => setIsContextMenuOpen(false),
    "data-test-subj": isContextMenuOpen ? 'embeddablePanelContextMenuOpen' : 'embeddablePanelContextMenuClosed'
  }, menuPanelsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    className: "embPanel__optionsMenuPopover-loading",
    title: _i18n.i18n.translate('presentationPanel.contextMenu.loadingTitle', {
      defaultMessage: 'Options'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null))) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "presentationPanelContextMenuItems",
    initialPanelId: "mainMenu",
    panels: contextMenuPanels
  }));
};
exports.PresentationPanelContextMenu = PresentationPanelContextMenu;